<?php

/**
 * PHP Script to benchmark PHP and MySQL-Server.
 *
 * inspired by / thanks to:
 * - www.php-benchmark-script.com (Alessandro Torrisi)
 * - www.webdesign-informatik.de
 *
 * @license MIT
 */

// -----------------------------------------------------------------------------
// Setup
// -----------------------------------------------------------------------------
set_time_limit(120); // 2 minutes

$options = [];

// Show or hide the server name and IP address
$showServerName = false;

// Optional: mysql performance test
$options['db.host'] = 'localhost';
$options['db.user'] = 'admrwn2_dbench';
$options['db.pw'] = 'dO5mB1dF5fZ0wZ3c';
$options['db.name'] = 'admrwn2_dbench';

// -----------------------------------------------------------------------------
// Main
// -----------------------------------------------------------------------------
// check performance
$benchmarkResult = test_benchmark($options);

// benchmark.php?json
if (isset($_GET['json'])) {
    // Json output
    header('Content-Type', 'application/json');
    echo json_encode($benchmarkResult, JSON_PRETTY_PRINT);
} else {
    // html output
    echo print_html_result($benchmarkResult, $showServerName);
}

exit;

// -----------------------------------------------------------------------------
// Benchmark functions
// -----------------------------------------------------------------------------

function test_benchmark(array $settings)
{
    $result = [];
    $result['version'] = '1.6';
    $result['sysinfo']['time'] = date('Y-m-d H:i:s');
    $result['sysinfo']['php_version'] = PHP_VERSION;
    $result['sysinfo']['platform'] = PHP_OS;
    $result['sysinfo']['server_name'] = $_SERVER['SERVER_NAME'];
    $result['sysinfo']['server_addr'] = $_SERVER['SERVER_ADDR'];
    $result['sysinfo']['xdebug'] = in_array('xdebug', get_loaded_extensions());

    $timeStart = microtime(true);

    test_math($result);
    test_string($result);
    test_loops($result);
    test_ifelse($result);

    $result['benchmark']['calculation'] = timer_diff($timeStart) . ' sec.';

    if (isset($settings['db.host'])) {
        test_mysql($result, $settings);
    }

    $result['benchmark']['total'] = timer_diff($timeStart) . ' sec.';

    return $result;
}

function test_math(&$result, $count = 99999)
{
    $timeStart = microtime(true);

    for ($i = 0; $i < $count; $i++) {
        sin($i);
        asin($i);
        cos($i);
        acos($i);
        tan($i);
        atan($i);
        abs($i);
        floor($i);
        exp($i);
        is_finite($i);
        is_nan($i);
        sqrt($i);
        log10($i);
    }

    $result['benchmark']['math'] = timer_diff($timeStart) . ' sec.';
}

function test_string(&$result, $count = 99999)
{
    $timeStart = microtime(true);

    $string = 'the quick brown fox jumps over the lazy dog';
    for ($i = 0; $i < $count; $i++) {
        addslashes($string);
        chunk_split($string);
        metaphone($string);
        strip_tags($string);
        md5($string);
        sha1($string);
        strtoupper($string);
        strtolower($string);
        strrev($string);
        strlen($string);
        soundex($string);
        ord($string);
    }
    $result['benchmark']['string'] = timer_diff($timeStart) . ' sec.';
}

function test_loops(&$result, $count = 999999)
{
    $timeStart = microtime(true);
    for ($i = 0; $i < $count; ++$i) {
    }

    $i = 0;
    while ($i < $count) {
        ++$i;
    }

    $result['benchmark']['loops'] = timer_diff($timeStart) . ' sec.';
}

function test_ifelse(&$result, $count = 999999)
{
    $timeStart = microtime(true);
    for ($i = 0; $i < $count; $i++) {
        if ($i == -1) {
        } elseif ($i == -2) {
        } else {
            if ($i == -3) {
            }
        }
    }
    $result['benchmark']['ifelse'] = timer_diff($timeStart) . ' sec.';
}

function test_mysql(&$result, $settings)
{
    $timeStart = microtime(true);

    $link = mysqli_connect($settings['db.host'], $settings['db.user'], $settings['db.pw']);
    $result['benchmark']['mysql_connect'] = timer_diff($timeStart) . ' sec.';

    mysqli_select_db($link, $settings['db.name']);
    $result['benchmark']['mysql_select_db'] = timer_diff($timeStart) . ' sec.';

    $dbResult = mysqli_query($link, 'SELECT VERSION() as version;');
    $arr_row = mysqli_fetch_array($dbResult);
    $result['sysinfo']['mysql_version'] = $arr_row['version'];
    $result['benchmark']['mysql_query_version'] = timer_diff($timeStart) . ' sec.';

    $query = "SELECT BENCHMARK(1000000, AES_ENCRYPT('hello', UNHEX('F3229A0B371ED2D9441B830D21A390C3')));";
    mysqli_query($link, $query);
    $result['benchmark']['mysql_query_benchmark'] = timer_diff($timeStart) . ' sec.';

    mysqli_close($link);

    $result['benchmark']['mysql_total'] = timer_diff($timeStart) . ' sec.';

    return $result;
}

function timer_diff($timeStart)
{
    return number_format(microtime(true) - $timeStart, 3);
}

function print_html_result(array $data, bool $showServerName = true)
{

    $result_data = array();
    $result_data['calculation_total'] = $data['benchmark']['calculation'];
    $result = 'Calculation total' . h(
            $data['benchmark']['calculation']
        ) . '';

    if (isset($data['sysinfo']['mysql_version'])) {
        $result_data['mysql_total'] = $data['benchmark']['mysql_total'];
        $result .= '\nMySQL Total' . h($data['benchmark']['mysql_total']) . '';
    }
    echo json_encode($result_data);
    #echo $result;

}

function h($v)
{
    return htmlentities($v);
}